#include "tap.h"

#define ID_POINTER_ARRAY 0x800000FF

TAP_ID( ID_POINTER_ARRAY );
TAP_PROGRAM_NAME("How To Access Array of Pointer");
TAP_AUTHOR_NAME("TOPFIELD");
TAP_DESCRIPTION("How To Access Array of Pointer");
TAP_ETCINFO(__DATE__);

// normal array:
// You must change the address of all elements as below.
// array[i] = array[i] + _tap_startAddr
char *strArray[4] =
{
	"string 1",
	"string 2",
	"string 3",
	"string 4",
};

// If you locate array to .xdata section,
// all address of element is automatically changed.
char *strArray_section_xdata[4] __attribute__ ((section(".xdata")))  =
{
	"string (section .xdata) 1",
	"string (section .xdata) 2",
	"string (section .xdata) 3",
	"string (section .xdata) 4",
};

// XDATA == __attribute__ ((section(".xdata")))
char *strArray_XDATA[4] XDATA = 
{
	"string (XDATA) 1",
	"string (XDATA) 2",
	"string (XDATA) 3",
	"string (XDATA) 4",
};

typedef struct
{
	int num;
	char *str;
} TYPE_Struct;

TYPE_Struct _struct_array[] =
{
	{ 0, "struct 1" },
	{ 1, "struct 2" },
	{ 2, "struct 3" },
	{ 3, "struct 4" },
};

dword TAP_EventHandler( word event, dword param1, dword param2 )
{
	return param1;
}

int TAP_Main(void)
{
	int i;

	// NORMAL Array
	for( i=0; i<4; i++ )
	{
		strArray[i] = (char *)((dword)(strArray[i]) + _tap_startAddr);
	}

	for( i=0; i<4; i++ )
	{
		TAP_Print("NORMAL Array [%d] : %s\n", i, strArray[i] );
	}

	// .xdata section
	for( i=0; i<4; i++ )
	{
		TAP_Print(".xdata Array [%d] : %s\n", i, strArray_section_xdata[i] );
	}
	
	// XDATA
	for( i=0; i<4; i++ )
	{
		TAP_Print("XDATA Array [%d] : %s\n", i, strArray_XDATA[i] );
	}
	
	// struct : You must change pointer value in array of struct.
	for( i=0; i<4; i++ )
	{
		_struct_array[i].str = (char *)((dword)(_struct_array[i].str) + _tap_startAddr);
	}
	
	for( i=0; i<4; i++ )
	{
		TAP_Print("struct %d : num = %d, str = %s\r\n", i, _struct_array[i].num, _struct_array[i].str );
	}
	
	return 0;
}

	
